
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   EPH_SEND.C - Ephemeris Send
// 
//
//   DESCRIPTION
//
//   Functions for sending ephemeris to and retrieving ephemeris from the
//   receiver.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\EPH_SEND.C_v  $
//   
//      Rev 1.15   09 Nov 1998 10:44:04   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 09:42:52   COLEJ
//   Multiple Changes...
//   
//      Rev 1.2   Feb 12 1997 16:04:54   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:00:42   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:22   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <string.h>
#include <share.h>

#include "LABMON.H"
#include "INITFUNC.H"
#include "MESS_IO.H"
#include "MONMISC.H"

extern char          buff[80];
extern unsigned char msgbuff[MAX_MSG_BUFFER];           
extern unsigned char tx_buff[MAX_TX_BUFFER];
extern unsigned char filebuff[4000];
extern short         cmdline; 
extern short         MainTextColor;  
extern short         MainDataColor;  
extern unsigned long Cnt1241;

extern tDATATYPE DataType;

static FILE  *Eph_FilePtr = NULL;

short get_ephemeris_file(void)
{
   short   option; 
   char  FileName[35];
   short   valid;                                            

   clear_message_line();  
   _outtext("SELECT FILE -> ");
   _settextcolor(MainTextColor);
   _outtext( "E" );
   _settextcolor(MainDataColor);
   _outtext( "PHEMERI.GPS  " );
   _settextcolor(MainTextColor);

   _outtext( "O" );
   _settextcolor(MainDataColor);
   _outtext( "THER" );

   option = getch();  
   clear_message_line();
   strcpy(FileName, "EPHEMERI.GPS");
   
   if(option != 'E' && option != 'e'){
      clear_message_line();
      ask_str("EPHEMERIS FILE NAME -> ", FileName, &valid);
      clear_message_line(); 
      if(!valid) return(1);     
   }
   clear_message_line(); 
      
   if((Eph_FilePtr = _fsopen(FileName, "rb", SH_DENYWR)) == NULL){
      clear_message_line();
      _outtext("COULDN'T OPEN ALMANAC FILE!\7");
      return(1);
   }
   else{
      return(0);
   }
}
 
short send_ephemeris(void)
{
   short i,svid; 
   
   if(Eph_FilePtr == NULL){
      return(1);
   }

   if(DataType == NC_BINARY){
      return(1);
   } //end if NC_BINARY
   
   if(DataType == Z_BINARY){
     // read another ephemeris record
     for(svid=1;svid<33;svid++){
       for(i=0;i<90;i++){
         if ((tx_buff[i] = (unsigned char)fgetc(Eph_FilePtr)) == EOF)return(0);
       }
       if(*(short*)(tx_buff+2) == 1241){
         cputs("\a");
         sprintf(buff, "EPHEMERIS sv = %d SENT",
      				(short)((tx_buff[13]<<8) | tx_buff[12]));
         clear_message_line();
         _outtext(buff);
         Cnt1241++;
         send_msg(tx_buff);
       }
     }
 
     return(0);
   } //end if Z_BINARY 
     
}


short store_eph(short file_len)
{
   short i;
   static short first_sv = 1;

   if(Eph_FilePtr == NULL) {
     if ((short)((filebuff[13]<<8) | filebuff[12]) > 0 &&
         (short)((filebuff[13]<<8) | filebuff[12]) < 33) {
       first_sv = 1;
       Eph_FilePtr = _fsopen("EPHEMERI.GPS", "wb", SH_DENYWR);
       if(Eph_FilePtr != NULL) {
         clear_message_line();
         _outtext("EPHEMERIS DATA FILE OPENED");
       }
     }
   } else {
     first_sv++;
   }
   
   if(Eph_FilePtr == NULL) {
      clear_message_line();
      _outtext("COULDN'T OPEN EPHEMERIS DATA FILE!");
      return(1);
   } else{
     if ((short)((filebuff[13]<<8) | filebuff[12]) > 0 &&
         (short)((filebuff[13]<<8) | filebuff[12]) < 33) {
       for(i=0;i<file_len; i++){
         fputc(filebuff[i], Eph_FilePtr);
       }
       sprintf(buff, "STORING EPHEMERIS DATA #%d FOR SV %d",
      				first_sv,(short)((filebuff[13]<<8) | filebuff[12]));
       clear_message_line();
       _outtext(buff);
     } else {
       sprintf(buff, "invalid EPHEMERIS DATA #%d FOR SV %d",
      				first_sv,(short)((filebuff[13]<<8) | filebuff[12]));
       clear_message_line();
       _outtext(buff);
       if(abs((short)((filebuff[13]<<8) | filebuff[12])) == 33) {// last sv so close file
         fclose(Eph_FilePtr);
         clear_message_line();
         _outtext("EPHEMERIS DATA FILE CLOSED     "); 
         first_sv = 1;
         Eph_FilePtr = NULL;
       }
     }
     return(0);
   }
}
